VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "BinaryFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'------------------------------------------------------------------
' Name : BinaryFile
'
' Purpose : Purpose an interface to save and read binary files
'
' Method:
'   1) CreateFile   Create a file
'   2) OpenFile     Open an existing file
'   3) ReadLine     Read one line of the opened file
'   4) WriteLine    Write one line in the created file
'   5) CloseFile    Close the current file
'
' review : 15/Feb/2000 by AD
'------------------------------------------------------------------

Const BF_NAME = "BinaryFile"
Const BF_VERSION = "1.0"

'List all the error that can existing
Public Enum BinaryFile_Error
    BF_OK = 0
    BF_File_Cannot_Be_Created = 1
    BF_File_Cannot_Be_Opened = 2
    BF_No_File_Opened = 3
    BF_File_Not_Exist = 4
    BF_File_Already_Exist = 5
    
    BF_File_Name_Not_Filled = 10
    BF_Column_Number_Not_Filled = 11
    BF_File_Not_For_Reading = 12
    BF_File_Not_For_Writing = 13
    BF_No_More_Data = 14
    
    
    BF_A_File_is_Currently_Opened = 20
    BF_No_More_File_Can_Be_Opened = 21
    BF_File_Not_Correctly_Formatted = 22
    
    BF_Undefined_Error = 100
End Enum

Private Enum StatusFile
    SF_NoStatus = 0
    SF_Read = 1
    SF_Write = 2
End Enum

Dim mb_ForceClose As Boolean
Dim mb_OverWrite As Boolean

Dim mo_StatusFile As StatusFile

Dim ms_FileName As String
Dim mi_ColumnNumber As Integer
Dim mi_id As Integer

Property Get isEOF() As Boolean
'------------------------------------------------------------------
' Name : isEOF (Get)
'
' Purpose : Indicates if the opened file is completely read
'
' Parameters : Nothing
'
' Return : Nothing
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    If mi_id = 0 Then
        isEOF = OK
    Else
        isEOF = EOF(mi_id)
    End If
End Property

Property Get OverWrite() As Boolean
'------------------------------------------------------------------
' Name : OverWrite (Get)
'
' Purpose : Return the current status of the overwrite property
'
' Parameters : Nothing
'
' Return : the current status of the overwrite property
'       OK: The CreateFile method overwrite the file if it exists
'       KO: The CreateFile fails if the file exists
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    OverWrite = mb_OverWrite
End Property

Property Let OverWrite(lb_OverWrite As Boolean)
'------------------------------------------------------------------
' Name : OverWrite (Let)
'
' Purpose : Change the current status of the overwrite property
'       OK: The CreateFile method overwrite the file if it exists
'       KO: The CreateFile fails if the file exists
'
' Parameters :
'       lb_OverWrite    Indicates the new value
'
' Return : Nothing
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    mb_OverWrite = lb_OverWrite
End Property

Property Get ForceClose() As Boolean
'------------------------------------------------------------------
' Name : ForceClose (Get)
'
' Purpose : Return the current status of the ForceClose property
'
' Parameters : Nothing
'
' Return : the current status of the ForceClose property
'       OK: When CreateFile or OpenFile is called and a file is
'           currently opened, these methods close the file
'       KO: CreateFile/OpenFile method fails if a file is opened
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    ForceClose = mb_ForceClose
End Property

Property Let ForceClose(lb_ForceClose As Boolean)
'------------------------------------------------------------------
' Name : ForceClose (Let)
'
' Purpose : Change the current status of the ForceClose property
'       OK: When CreateFile or OpenFile is called and a file is
'           currently opened, these methods close the file
'       KO: CreateFile/OpenFile method fails if a file is opened
'
' Parameters :
'       lb_ForceClose   Indicates the new value
'
' Return : Nothing
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    mb_ForceClose = lb_ForceClose
End Property

Property Get ColumnNumber() As Integer
'------------------------------------------------------------------
' Name : ColumnNumber (Get)
'
' Purpose : Indicates the column number for each line
'
' Parameters : Nothing
'
' Return : the column number
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    ColumnNumber = mi_ColumnNumber
End Property

Property Let ColumnNumber(li_ColumnNumber As Integer)
'------------------------------------------------------------------
' Name : ColumnNumber (Let)
'
' Purpose : Changes the column number for each line
'
' Parameters :
'       li_ColumnNumber     Indicates the new column number
'
' Return : Nothing
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    mi_ColumnNumber = li_ColumnNumber
End Property

Property Get NameFile() As String
'------------------------------------------------------------------
' Name : NameFile (Get)
'
' Purpose : Indicates the name of the file that we have/want create
'           or open
'
' Parameters : Nothing
'
' Return : the filename
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    NameFile = ms_FileName
End Property

Property Let NameFile(ls_Filename As String)
'------------------------------------------------------------------
' Name : NameFile (Let)
'
' Purpose : Change the name of the file that we have/want create
'           or open
'
' Parameters :
'       ls_FileName     Indicates the new filename
'
' Return : Nothing
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    ms_FileName = ls_Filename
End Property

Public Function CreateFile() As BinaryFile_Error
'------------------------------------------------------------------
' Name : CreateFile
'
' Purpose : Create the file. Depends of the different properties
'
' Parameters : Nothing
'
' Return : the eventually error
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ls_top As String

    'If we don't know the file name, we exit
    If ms_FileName = "" Then
        CreateFile = BF_File_Name_Not_Filled
        Exit Function
    End If
    
    'If we don't know the column number, we exit
    If mi_ColumnNumber = 0 Then
        CreateFile = BF_Column_Number_Not_Filled
        Exit Function
    End If
    
    'If a file is open with this class, we close it
    'if the force close option is true
    If mi_id <> 0 Then
        If mb_ForceClose = OK Then
            CloseFile
        Else
            CreateFile = BF_A_File_is_Currently_Opened
            Exit Function
        End If
    End If
    
    'We verify, if the file already exist
    If Dir(ms_FileName) <> "" Then
        If mb_OverWrite = KO Then
            CreateFile = BF_File_Already_Exist
            Exit Function
        Else
            'We can overwrite the file, so we kill it
            On Error Resume Next
            Kill ms_FileName
            On Error GoTo 0
        End If
    End If
    
    CreateFile = BF_OK
    
    On Error GoTo CreateFile_UndefinedErr
    
    'We use a new id
    mi_id = FreeFile

    If Not mi_id > 0 Then
        CreateFile = BF_No_More_File_Can_Be_Opened
        Exit Function
    End If

    On Error GoTo CreateFile_OpenErr
    
    Open ms_FileName For Binary Access Write Lock Read Write As mi_id

    On Error GoTo CreateFile_UndefinedErr

    'Write the top File to identify it
    ls_top = BF_NAME
    WriteValue ls_top
    
    ls_top = BF_VERSION
    WriteValue ls_top

    'Write the column number of each line
    Put mi_id, , mi_ColumnNumber

    mo_StatusFile = SF_Write

    Exit Function
    
CreateFile_OpenErr:

    mi_id = 0
    CreateFile = BF_File_Cannot_Be_Created
    
    Exit Function

CreateFile_UndefinedErr:
    'We have an error
    mi_id = 0
    
    CreateFile = BF_Undefined_Error

End Function

Public Function OpenFile() As BinaryFile_Error
'------------------------------------------------------------------
' Name : OpenFile
'
' Purpose : Open the file. Depends of the different properties
'
' Parameters : Nothing
'
' Return : the eventually error
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ls_top As String

    'If we don't know the file name, we exit
    If ms_FileName = "" Then
        OpenFile = BF_File_Name_Not_Filled
        Exit Function
    End If
    
    'If a file is open with this class, we close it
    'if the force close option is true
    If mi_id <> 0 Then
        If mb_ForceClose = OK Then
            CloseFile
        Else
            OpenFile = BF_A_File_is_Currently_Opened
            Exit Function
        End If
    End If

    'We verify, if the file already exist
    If Dir(ms_FileName) = "" Then
        OpenFile = BF_File_Not_Exist
        Exit Function
    End If
    
    OpenFile = BF_OK
    
    On Error GoTo OpenFile_UndefinedErr
    
    'We use a new id
    mi_id = FreeFile

    If Not mi_id > 0 Then
        OpenFile = BF_No_More_File_Can_Be_Opened
        Exit Function
    End If

    On Error GoTo OpenFile_OpenErr
    
    Open ms_FileName For Binary Access Read Lock Read Write As mi_id

    On Error GoTo OpenFile_UndefinedErr

    'Read the top File to identify it
    ls_top = ReadValue
    
    If ls_top <> BF_NAME Then
        OpenFile = BF_File_Not_Correctly_Formatted
        CloseFile
        Exit Function
    End If
    
    'We read the version, but we don't test it in this version
    ls_top = ReadValue

    'Read the column number of each line
    Get mi_id, , mi_ColumnNumber
    
    mo_StatusFile = SF_Read
    
    Exit Function

OpenFile_OpenErr:

    mi_id = 0
    OpenFile = BF_File_Cannot_Be_Opened
    
    Exit Function

OpenFile_UndefinedErr:
    'We have an error
    CloseFile
    OpenFile = BF_Undefined_Error

End Function

Public Function CloseFile() As BinaryFile_Error
'------------------------------------------------------------------
' Name : CloseFile
'
' Purpose : Close the current file
'
' Parameters : Nothing
'
' Return : the eventually error
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------

    If mi_id = 0 Then
        CloseFile = BF_No_File_Opened
        Exit Function
    End If

    CloseFile = BF_OK
    
    On Error GoTo CloseFile_UndefinedErr

    Close mi_id
    
    mi_id = 0
    mo_StatusFile = SF_NoStatus
    
    Exit Function
    
CloseFile_UndefinedErr:
    mi_id = 0
    ms_FileName = ""
    mi_ColumnNumber = 0
    mo_StatusFile = SF_NoStatus
    
    CloseFile = BF_Undefined_Error
    
End Function

Public Function ReadLine(ByRef la_Column() As String) As BinaryFile_Error
'------------------------------------------------------------------
' Name : ReadLine
'
' Purpose : Read one line of a number of columns
'
' Parameters :
'       la_Column   The table where return the values
'
' Return : the eventually error and the column values
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim i As Integer

    'Verify if a file is opened
    If mi_id = 0 Then
        ReadLine = BF_No_File_Opened
        Exit Function
    End If

    'Verify if a file is opened in read status
    If mo_StatusFile <> SF_Read Then
        ReadLine = BF_File_Not_For_Reading
        Exit Function
    End If

    If EOF(mi_id) Then
        ReadLine = BF_No_More_Data
        Exit Function
    End If
    
    ReadLine = BF_OK
    
    On Error GoTo ReadLine_UndefinedError

    For i = 1 To mi_ColumnNumber
        la_Column(i - 1) = ReadValue
        If EOF(mi_id) Then
            ReadLine = BF_No_More_Data
            Exit Function
        End If
    Next

    Exit Function
    
ReadLine_UndefinedError:
    ReadLine = BF_Undefined_Error

End Function

Public Function WriteLine(ByRef la_Column() As String) As BinaryFile_Error
'------------------------------------------------------------------
' Name : WriteLine
'
' Purpose : Write one line of a number of columns
'
' Parameters :
'       la_Column   The value for each column
'
' Return : the eventually error
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim i As Integer

    'Verify if a file is opened
    If mi_id = 0 Then
        WriteLine = BF_No_File_Opened
        Exit Function
    End If

    'Verify if a file is opened in write status
    If mo_StatusFile <> SF_Write Then
        WriteLine = BF_File_Not_For_Writing
        Exit Function
    End If

    WriteLine = BF_OK

    On Error GoTo WriteLine_UndefinedError

    For i = 1 To mi_ColumnNumber
        WriteValue la_Column(i - 1)
    Next

    Exit Function
    
WriteLine_UndefinedError:
    WriteLine = BF_Undefined_Error

End Function

Private Function ReadValue() As String
'------------------------------------------------------------------
' Name : ReadValue
'
' Purpose : Read one value in the file
'
' Parameters : Nothing
'
' Return : the value
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ll_size As Long

    Get mi_id, , ll_size
    
    ReadValue = String(ll_size, " ")
    Get mi_id, , ReadValue

End Function

Private Sub WriteValue(ls_value As String)
'------------------------------------------------------------------
' Name : WriteValue
'
' Purpose : Write one value in the file
'
' Parameters :
'       ls_value    The value to write
'
' Return : Nothing
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ll_size As Long

    ll_size = Len(ls_value)
    Put mi_id, , ll_size
    Put mi_id, , ls_value

End Sub

Private Sub Class_Initialize()
'------------------------------------------------------------------
' Name : Initialize
'
' Purpose : Initialize all the tables and properties
'
' Parameters : Nothing
'
' Return : Nothing
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    'The class is new, we have no id used
    mi_id = 0
    'The filename is free
    ms_FileName = ""
    'We don't know the column number
    mi_ColumnNumber = 0
    'We don't force closed of a precedent file
    mb_ForceClose = KO
    'We don't overwrite existing file by default
    mb_OverWrite = KO
    'We don't have opened status for the current file
    mo_StatusFile = SF_NoStatus
End Sub

Private Sub Class_Terminate()
'------------------------------------------------------------------
' Name : Terminate
'
' Purpose : Terminate the instanciation.
'
' Parameters : Nothing
'
' Return : Nothing
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    'If a file is open with this class, we close it
    If mi_id <> 0 Then CloseFile
End Sub
